#-----------------------------------------------------------------------------
"""
 LightPanel

June 17, 2004
slightly changed 8/31/05, just to reflect the realization that Local and Point
are the same thing.

 Copyright (c) 2004, David G. Drumright (ockham)

 Using a sneaky trick to get around a P5 Python limitation.  This
 won't work for many things, but it does work for lights.  We can't
 adjust the new features in Python, but we can save a temp LT2 file,
 delete existing lights, modify the LT2, and reload it.

"""

#-----------------------------------------------------------------------------

import random
random.seed()

from Tkinter import *
root = Tk()

import poser
scene = poser.Scene()

#-----------------------------------------------------------------------------

global IconChoice, ISLChoice
global OnChoice, NDRChoice, AnimChoice

global UseRed, Red
global UseGreen, Green
global UseBlue, Blue
global UseIntens, Intens
global UseShadow, Shadow
global UseMapSize, MapSize
global UseMinBias, MinBias
global UseRand, Rand
global UseDistEnd, DistEnd
global UseParent,NewParent
global UsePointAt
global LightList

IconChoice = -1
ISLChoice = -1
OnChoice = -1
NDRChoice = -1
AnimChoice = -1

UseBlur = 0
UseRed = 0
UseGreen = 0
UseBlue = 0
UseIntens = 0
UseShadow = 0
UseMapSize = 0
UseMinBias = 0
UseBlur = 0
UseRand = 0
UseDistEnd = 0
UseParent = 0
UsePointAt = 0

NewParent = ""

LightList = []

#------------------------------------------------------------

def ParameterActions():
	global IconChoice, ISLChoice
	global UseRed, Red
	global UseMinBias,MinBias
	global UseGreen, Green
	global UseBlue, Blue
	global UseIntens, Intens
	global UseShadow, Shadow
	global UseMapSize, MapSize
	global UseRand, Rand
	global UseDistEnd, DistEnd
	global UseParent, NewParent
	global UsePointAt
	global LightList

	for OneActor in LightList:
		# Use the dummy values to determine which vars have actually
		# been touched.
		if IconChoice == 2: # special for delete
			scene.SelectActor(OneActor)
			scene.DeleteCurrentProp()		  # Wipe it.

		elif IconChoice > -1:
			OneActor.SetOnOff(IconChoice)

		if ISLChoice > -1:
			OneActor.SetLightType(ISLChoice)

		if UseRed:
			Parm = OneActor.Parameter("Red")
			Parm.SetValue(Red)

		if UseGreen:
			Parm = OneActor.Parameter("Green")
			Parm.SetValue(Green)

		if UseBlue:
			Parm = OneActor.Parameter("Blue")
			Parm.SetValue(Blue)

		if UseMinBias:
			OneActor.SetShadowBiasMin(MinBias)

		if UseIntens:
			Parm = OneActor.Parameter("Intensity")
			Parm.SetValue(Intens/100.0) # Do the de-percent here

		if UseShadow:
			Parm = OneActor.Parameter("Shadow")
			Parm.SetValue(Shadow)

		if UseMapSize:
			Parm = OneActor.Parameter("Map Size")
			Parm.SetValue(MapSize)

		if UseRand:  # Not really a parm. Move locations around a little bit.
			Parm = OneActor.Parameter("xRotate")
			DegMult = 360.0 * Rand/100.0
			DegHalf = DegMult / 2.0
			NewVal = Parm.Value() + random.random() * DegMult - DegHalf
			Parm.SetValue(NewVal)
			Parm = OneActor.Parameter("yRotate")
			NewVal = Parm.Value() + random.random() * DegMult - DegHalf
			Parm.SetValue(NewVal)
			Parm = OneActor.Parameter("zRotate")
			NewVal = Parm.Value() + random.random() * DegMult - DegHalf
			Parm.SetValue(NewVal)

		if UseDistEnd:
			# Have to check whether the light is currently set to spot
			# mode, because the parm only exists for spot mode.
			if OneActor.LightType() == 1:  # If is spot
				Parm = OneActor.Parameter("Dist End")
				Parm.SetValue(DistEnd) # Whether we forced or not

		if UseParent: # Set parent of all to given item.
			OneActor.SetParent(NewParent)

#------------------------------------------------------------

def P5FileActions():
	global app
	global OnChoice, NDRChoice, AnimChoice
	global UseBlur, Blur
	global UseMinBias, MinBias
	global UsePointAt

	NameIn = "templite.lt2"
	NameOut = "modlite.lt2"

	# We check each individually when setting a line, but
	# just for safety, skip entirely if all are default.
	if NDRChoice < 0:
		if OnChoice < 0:
			if AnimChoice < 0:
				if not UseBlur:
					if not UseMinBias:
						if not UsePointAt:
							return


	scene.SaveLibraryLight(NameIn)

	try:
		FileIn	= open(NameIn,"r")
	except:
		raise "Input file not found."
	try:
		FileOut = open(NameOut,"w")
	except:
		raise "Output file can't be opened; may be already present."

	LineIn = ""
	LineOut = ""

	while 1:
		LineIn = FileIn.readline()
		if not LineIn: break

		elif string.count(LineIn,"lightOn") and (OnChoice >= 0 ):
			LineOut = "    lightOn %d\n" % OnChoice

		elif string.count(LineIn,"static") and (AnimChoice >= 0 ):
			LineOut = "        static %d\n" % (1 - AnimChoice)

		elif string.count(LineIn,"shadowBlurRadius") and (UseBlur):
			LineOut = "    shadowBlurRadius %f\n" % Blur

		elif string.count(LineIn,"shadowBiasMin") and (UseMinBias):
			LineOut = "    shadowBiasMin %f\n" % MinBias

		elif string.count(LineIn,"doShadow"):
			if (NDRChoice > 0):
				LineOut = "    doShadow 1\n"
			else:
				LineOut = "    doShadow 0\n"

		elif string.count(LineIn,"rayTraceShadows"):
			if (NDRChoice == 1):
			   LineOut = "    rayTraceShadows 0\n"
			elif (NDRChoice == 2):
			   LineOut = "    rayTraceShadows 1\n"

		elif string.count(LineIn,"depthMapShadows"):
			if (NDRChoice == 1):
				LineOut = "    depthMapShadows 1\n"
			elif (NDRChoice == 2):
				LineOut = "    depthMapShadows 0\n"

		elif string.count(LineIn,"pointAtTarget"):
			if (UsePointAt == 1): # Requested elimination
				# It would be best to eliminate the paragraph, but
				# this should work.
				LineOut = "            pointAtTarget UNIVERSE\n"

		else:  # All other lines, just copy.
			LineOut = LineIn

		FileOut.write(LineOut)

	# end main read loop
	FileIn.close()
	FileOut.close()
	# End use of files.

	# Delete existing lights so we don't duplicate: (this may not be necessary?)
	for OneLight in scene.Lights():
		scene.SelectActor(OneLight)
		scene.DeleteCurrentProp()

	# Now reload the new setup.
	scene.LoadLibraryLight(NameOut)

	# Now get rid of the tempfiles.

	try:
		os.remove(NameIn)
		os.remove(NameOut)
		os.remove("templite.png")
		os.remove("modlite.png")
	except:
		pass

#------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
	def __init__(self, master, textMessage):
		self.master = master
		master.title("Change some or all lights")

		self.ListFrame = Frame(self.master,borderwidth=2,relief=RIDGE)
		self.ListFrame.grid(row=2,column=1)

		self.ButtonFrame = Frame(self.master,borderwidth=2,relief=RIDGE)
		self.ButtonFrame.grid(row=2,column=2)

		# Give all the Vars dummy values, outside possible range,
		# so we can tell when any has been set without having
		# to sense mouse events.

		# Vars to handle the Radiobuttons:
		self.NDRVar = IntVar()
		self.NDRVar.set(-1) # default for no change
		self.ISLVar    = IntVar()
		self.ISLVar.set(-1) # default for no change
		self.IconVar	  = IntVar()
		self.IconVar.set(-1)
		self.OnVar		  = IntVar()
		self.OnVar.set(-1)
		self.AnimVar = IntVar()
		self.AnimVar.set(-1)

		# Vars for Checkbuttons (whether to use the numerical value)
		self.RedVar = IntVar()
		self.RedVar.set(0)
		self.GreenVar = IntVar()
		self.GreenVar.set(0)
		self.BlueVar = IntVar()
		self.BlueVar.set(0)
		self.IntensVar = IntVar()
		self.IntensVar.set(0)
		self.ShadowVar = IntVar()
		self.ShadowVar.set(0)
		self.MapSizeVar = IntVar()
		self.MapSizeVar.set(0)
		self.MinBiasVar = IntVar()
		self.MinBiasVar.set(0)
		self.BlurVar = IntVar()
		self.BlurVar.set(0)
		self.RandVar = IntVar()
		self.RandVar.set(0)
		self.DistEndVar = IntVar()
		self.DistEndVar.set(0)
		self.ParentVar = IntVar()
		self.ParentVar.set(0)
		self.PointAtVar = IntVar()
		self.PointAtVar.set(0)
		# Reminder: we don't have Vars for the slider values;
		# we just pick them up into globals.



		Instruct = Label(master, text="Each variable you check will affect all lights or selected lights." )
		Instruct.grid(row=0, sticky=W, columnspan=4)

		self.Scroll  = Scrollbar(self.ListFrame, orient=VERTICAL)
		self.Scroll.grid( row=0, column=0,sticky=N+S+E)
		self.Box  = Listbox(self.ListFrame, height=20, selectmode=MULTIPLE,yscrollcommand = self.Scroll.set)
		self.Box.grid( row=0, column=1)
		# Fill with names of existing lights
		for OneLight in scene.Lights():
			self.Box.insert(END,OneLight.Name())

		Label(self.ButtonFrame, text="Icon visible:" ).grid(row=1, column=1)
		self.IconOnCheck = Radiobutton(self.ButtonFrame,variable=self.IconVar,value=1)
		self.IconOnCheck.grid(row=1, column=2)
		Label(self.ButtonFrame, text="Icon invisible:" ).grid(row=1, column=3)
		self.IconOffCheck = Radiobutton(self.ButtonFrame,variable=self.IconVar,value=0)
		self.IconOffCheck.grid(row=1, column=4)
		Label(self.ButtonFrame, text="Delete:" ).grid(row=1, column=5) # Somewhat out of place
		self.DeleteCheck = Radiobutton(self.ButtonFrame,variable=self.IconVar,value=2)
		self.DeleteCheck.grid(row=1, column=6)

		Label(self.ButtonFrame, text="Light on:" ).grid(row=2, column=1)
		self.LightOnCheck = Radiobutton(self.ButtonFrame,variable=self.OnVar,value=1)
		self.LightOnCheck.grid(row=2, column=2)
		Label(self.ButtonFrame, text="Light off:" ).grid(row=2, column=3)
		self.LightOnCheck = Radiobutton(self.ButtonFrame,variable=self.OnVar,value=0)
		self.LightOnCheck.grid(row=2, column=4)

		Label(self.ButtonFrame, text="Animating on:" ).grid(row=3, column=1)
		self.AnimOnCheck = Radiobutton(self.ButtonFrame,variable=self.AnimVar,value=1)
		self.AnimOnCheck.grid(row=3, column=2)
		Label(self.ButtonFrame, text="Animating off:" ).grid(row=3, column=3)
		self.AnimOffCheck = Radiobutton(self.ButtonFrame,variable=self.AnimVar,value=0)
		self.AnimOffCheck.grid(row=3, column=4)

		Label(self.ButtonFrame, text="Infinite:" ).grid(row=4, column=1)
		self.InfiniteCheck = Radiobutton(self.ButtonFrame,variable=self.ISLVar,value=0)
		self.InfiniteCheck.grid(row=4, column=2)
		Label(self.ButtonFrame, text="Spot:" ).grid(row=4, column=3)
		self.SpotCheck = Radiobutton(self.ButtonFrame,variable=self.ISLVar,value=1)
		self.SpotCheck.grid(row=4, column=4)
		Label(self.ButtonFrame, text="Point:" ).grid(row=4, column=5)
		self.PointCheck = Radiobutton(self.ButtonFrame,variable=self.ISLVar,value=2)
		self.PointCheck.grid(row=4, column=6)

		Label(self.ButtonFrame, text="DepthMap:" ).grid(row=5, column=1)
		self.DepthCheck = Radiobutton(self.ButtonFrame,variable=self.NDRVar,value=1)
		self.DepthCheck.grid(row=5, column=2)
		Label(self.ButtonFrame, text="RayTrace:" ).grid(row=5, column=3)
		self.RayCheck = Radiobutton(self.ButtonFrame,variable=self.NDRVar,value=2)
		self.RayCheck.grid(row=5, column=4)
		Label(self.ButtonFrame, text="Neither:" ).grid(row=5, column=5)
		self.NeitherCheck = Radiobutton(self.ButtonFrame,variable=self.NDRVar,value=0)
		self.NeitherCheck.grid(row=5, column=6)

		#----------------

		Label(self.ButtonFrame, text='Red').grid(row=6,sticky=W)
		self.RedCheck = Checkbutton(self.ButtonFrame,variable=self.RedVar)
		self.RedCheck.grid(row=6,column=1)
		self.RedSlider = Scale(self.ButtonFrame, from_=0.0, to=1.0,orient=HORIZONTAL,resolution=0.01,showvalue=0)
		self.RedSlider.grid(row=6, column=2,columnspan=3)
		self.RedSlider.set(0.0)
		self.RedShow = Entry(self.ButtonFrame,width=5)
		self.RedShow.grid(row=6,column=5)

		Label(self.ButtonFrame, text='Green').grid(row=7,sticky=W)
		self.GreenCheck = Checkbutton(self.ButtonFrame,variable=self.GreenVar)
		self.GreenCheck.grid(row=7,column=1)
		self.GreenSlider = Scale(self.ButtonFrame, from_=0.0, to=1.0,orient=HORIZONTAL,resolution=0.01,showvalue=0)
		self.GreenSlider.grid(row=7, column=2,columnspan=3)
		self.GreenSlider.set(0.0)
		self.GreenShow = Entry(self.ButtonFrame,width=5)
		self.GreenShow.grid(row=7,column=5)

		Label(self.ButtonFrame, text='Blue').grid(row=8,sticky=W)
		self.BlueCheck = Checkbutton(self.ButtonFrame,variable=self.BlueVar)
		self.BlueCheck.grid(row=8,column=1)
		self.BlueSlider = Scale(self.ButtonFrame, from_=0.0, to=1.0,orient=HORIZONTAL,resolution=0.01,showvalue=0)
		self.BlueSlider.grid(row=8, column=2,columnspan=3)
		self.BlueSlider.set(0.0)
		self.BlueShow = Entry(self.ButtonFrame,width=5)
		self.BlueShow.grid(row=8,column=5)

		Label(self.ButtonFrame, text='Intensity').grid(row=9,sticky=W)
		self.IntensCheck = Checkbutton(self.ButtonFrame,variable=self.IntensVar)
		self.IntensCheck.grid(row=9,column=1)
		self.IntensSlider = Scale(self.ButtonFrame, from_=0, to=100,orient=HORIZONTAL,resolution=1,showvalue=0)
		self.IntensSlider.grid(row=9, column=2,columnspan=3)
		self.IntensSlider.set(0)
		self.IntensShow = Entry(self.ButtonFrame,width=5)
		self.IntensShow.grid(row=9,column=5)

		Label(self.ButtonFrame, text='Shadow').grid(row=10,sticky=W)
		self.ShadowCheck = Checkbutton(self.ButtonFrame,variable=self.ShadowVar)
		self.ShadowCheck.grid(row=10,column=1)
		self.ShadowSlider = Scale(self.ButtonFrame, from_=0.0, to=1.0,orient=HORIZONTAL,resolution=0.1,showvalue=0)
		self.ShadowSlider.grid(row=10, column=2,columnspan=3)
		self.ShadowSlider.set(0.0)
		self.ShadowShow = Entry(self.ButtonFrame,width=5)
		self.ShadowShow.grid(row=10,column=5)

		Label(self.ButtonFrame, text='Map Size').grid(row=11,sticky=W)
		self.MapCheck = Checkbutton(self.ButtonFrame,variable=self.MapSizeVar)
		self.MapCheck.grid(row=11,column=1)
		self.MapSlider = Scale(self.ButtonFrame, from_=64, to=1024,orient=HORIZONTAL,resolution=1,showvalue=0)
		self.MapSlider.grid(row=11, column=2,columnspan=3)
		self.MapSlider.set(64)
		self.MapShow = Entry(self.ButtonFrame,width=5)
		self.MapShow.grid(row=11,column=5)

		Label(self.ButtonFrame, text='Shadow Bias').grid(row=12,sticky=W)
		self.MinCheck = Checkbutton(self.ButtonFrame,variable=self.MinBiasVar)
		self.MinCheck.grid(row=12,column=1)
		self.MinSlider = Scale(self.ButtonFrame, from_=0.0, to=40.0,orient=HORIZONTAL,resolution=0.01,showvalue=0)
		self.MinSlider.grid(row=12, column=2,columnspan=3)
		self.MinSlider.set(0.0)
		self.MinShow = Entry(self.ButtonFrame,width=5)
		self.MinShow.grid(row=12,column=5)

		Label(self.ButtonFrame, text='Shadow Blur').grid(row=13,sticky=W)
		self.BlurCheck = Checkbutton(self.ButtonFrame,variable=self.BlurVar)
		self.BlurCheck.grid(row=13,column=1)
		self.BlurSlider = Scale(self.ButtonFrame, from_=1, to=12,orient=HORIZONTAL,resolution=1,showvalue=0)
		self.BlurSlider.grid(row=13, column=2,columnspan=3)
		self.BlurSlider.set(1)
		self.BlurShow = Entry(self.ButtonFrame,width=5)
		self.BlurShow.grid(row=13,column=5)

		Label(self.ButtonFrame, text='Rand angles').grid(row=14,sticky=W)
		self.RandCheck = Checkbutton(self.ButtonFrame,variable=self.RandVar)
		self.RandCheck.grid(row=14,column=1)
		self.RandSlider = Scale(self.ButtonFrame, from_=0, to=100,orient=HORIZONTAL,resolution=1,showvalue=0)
		self.RandSlider.grid(row=14, column=2,columnspan=3)
		self.RandSlider.set(0)
		self.RandShow = Entry(self.ButtonFrame,width=5)
		self.RandShow.grid(row=14,column=5)

		Label(self.ButtonFrame, text='Dist End').grid(row=15,sticky=W)
		self.DistEndCheck = Checkbutton(self.ButtonFrame,variable=self.DistEndVar)
		self.DistEndCheck.grid(row=15,column=1)
		self.DistEndSlider = Scale(self.ButtonFrame, from_=0.0, to=20.0,orient=HORIZONTAL,resolution=0.1,showvalue=0)
		self.DistEndSlider.grid(row=15, column=2,columnspan=3)
		self.DistEndSlider.set(0)
		self.DistEndShow = Entry(self.ButtonFrame,width=5)
		self.DistEndShow.grid(row=15,column=5)

		Label(self.ButtonFrame, text='New Parent').grid(row=16,sticky=W)
		self.ParentCheck = Checkbutton(self.ButtonFrame,variable=self.ParentVar)
		self.ParentCheck.grid(row=16,column=1)
		self.ParentEntry = Entry(self.ButtonFrame)
		self.ParentEntry.grid(row=16, column=2,columnspan=3)

		Label(self.ButtonFrame, text='No point-at').grid(row=17,sticky=W)
		self.PointAtCheck = Checkbutton(self.ButtonFrame,variable=self.PointAtVar)
		self.PointAtCheck.grid(row=17,column=1)

		# buttons for Go, cancel.
		self.buttonGo = Button(self.ListFrame, text="Apply to all", command=self.HandleGo,bg="pink")
		self.buttonGo.grid(row=3, column=0)

		self.buttonSelect = Button(self.ListFrame, text="Apply to Selected", command=self.HandleSelect,bg="lightblue")
		self.buttonSelect.grid(row=3, column=1)

		# Set the scrollbar to work
		self.Scroll["command"] = self.Box.yview

		# Tie the slide handler to mouse-release on all sliders
		self.RedSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowRed)
		self.GreenSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowGreen)
		self.BlueSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowBlue)
		self.IntensSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowIntens)
		self.ShadowSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowShadow)
		self.MapSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowMap)
		self.MinSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowMin)
		self.BlurSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowBlur)
		self.RandSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowRand)
		self.DistEndSlider.bind(sequence='<ButtonRelease-1>',func=self.ShowDistEnd)

		# Force the initial values to show in the ***Show boxes.
		self.RedShow.insert(END,"%1.3f" % 0.0 )
		self.GreenShow.insert(END,"%1.3f" % 0.0 )
		self.BlueShow.insert(END,"%1.3f" % 0.0 )
		self.IntensShow.insert(END,"%3d" % 0.0 )
		self.ShadowShow.insert(END,"%1.3f" % 0.0 )
		self.MapShow.insert(END,"%2d" % 64 )
		self.MinShow.insert(END,"%1.3f" % 0.0 )
		self.BlurShow.insert(END,"%2d" % 1 )
		self.RandShow.insert(END,"%3d" % 0 )
		self.DistEndShow.insert(END,"%1.3f" % 0.0 )

		self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

	# - - - - - - - - - - - - - - - - - -

	def FillGlobals(self):
		global IconChoice, ISLChoice
		global OnChoice,   NDRChoice, AnimChoice
		global UseRed,	   Red
		global UseGreen,   Green
		global UseBlue,    Blue
		global UseIntens,  Intens
		global UseShadow,  Shadow
		global UseMapSize, MapSize
		global UseMinBias, MinBias
		global UseBlur,    Blur
		global UseRand,    Rand
		global UseDistEnd, DistEnd
		global UseParent,  NewParent
		global UsePointAt

		# Set the three-way globals from radiobuttons.
		IconChoice = self.IconVar.get()
		ISLChoice  = self.ISLVar.get()
		OnChoice   = self.OnVar.get()
		NDRChoice  = self.NDRVar.get()
		AnimChoice = self.AnimVar.get()

		# Set the Use globals from checkboxes.
		UseRed	   = self.RedVar.get()
		UseGreen   = self.GreenVar.get()
		UseBlue    = self.BlueVar.get()
		UseIntens  = self.IntensVar.get()
		UseShadow  = self.ShadowVar.get()
		UseMapSize = self.MapSizeVar.get()
		UseMinBias = self.MinBiasVar.get()
		UseBlur    = self.BlurVar.get()
		UseRand    = self.RandVar.get()
		UseDistEnd = self.DistEndVar.get()
		UseParent  = self.ParentVar.get()
		UsePointAt = self.PointAtVar.get()

		# set the Numerical globals from the sliders.
		Red 	   = float(self.RedSlider.get())
		Green	   = float(self.GreenSlider.get())
		Blue	   = float(self.BlueSlider.get())
		Intens	   = int(self.IntensSlider.get())
		Shadow	   = float(self.ShadowSlider.get())
		MapSize    = int(self.MapSlider.get())
		MinBias    = float(self.MinSlider.get())
		Blur	   = float(self.BlurSlider.get())
		Rand	   = float(self.RandSlider.get())
		DistEnd    = float(self.DistEndSlider.get())

		# If UseParent is checked, get the actor from the
		# parent string.  If parent string is empty and UseParent
		# is checked, set parent to "UNIVERSE".
		if UseParent:
			NewParent = "UNIVERSE"
			try:
				TryParent = self.ParentEntry.get()
			except:
				pass # Leave as Universe.
			try:
				NewParent = scene.Actor(TryParent)
			except:
				UseParent = 0 # Specified actor not present.


	# - - - - - - - - - - - - - - - - - -
	def SeeColor(self):
		R = float(self.RedSlider.get())*256
		G = float(self.GreenSlider.get())*256
		B = float(self.BlueSlider.get())*256
		AllHex="#%.2x%.2x%.2x" % (R,G,B)
		self.ListFrame.config(bg=AllHex)
	# - - - - - - - - - - - - - - - - - -
	def ShowRed(self,event):
		self.RedShow.delete(0,END)
		self.RedShow.insert(END,"%1.3f" % event.widget.get() )
		self.RedShow.update_idletasks()
		self.SeeColor()
	# - - - - - - - - - - - - - - - - - -
	def ShowGreen(self,event):
		self.GreenShow.delete(0,END)
		self.GreenShow.insert(END,"%1.3f" % event.widget.get() )
		self.GreenShow.update_idletasks()
		self.SeeColor()
	# - - - - - - - - - - - - - - - - - -
	def ShowBlue(self,event):
		self.BlueShow.delete(0,END)
		self.BlueShow.insert(END,"%1.3f" % event.widget.get() )
		self.BlueShow.update_idletasks()
		self.SeeColor()
	# - - - - - - - - - - - - - - - - - -
	def ShowIntens(self,event):
		self.IntensShow.delete(0,END)
		self.IntensShow.insert(END,"%3d" % event.widget.get() )
		self.IntensShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowShadow(self,event):
		self.ShadowShow.delete(0,END)
		self.ShadowShow.insert(END,"%1.3f" % event.widget.get() )
		self.ShadowShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowMap(self,event):
		self.MapShow.delete(0,END)
		self.MapShow.insert(END,"%2d" % event.widget.get() )
		self.MapShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowMin(self,event):
		self.MinShow.delete(0,END)
		self.MinShow.insert(END,"%1.3f" % event.widget.get() )
		self.MinShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowBlur(self,event):
		self.BlurShow.delete(0,END)
		self.BlurShow.insert(END,"%2d" % event.widget.get() )
		self.BlurShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowRand(self,event):
		self.RandShow.delete(0,END)
		self.RandShow.insert(END,"%3d" % event.widget.get() )
		self.RandShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -
	def ShowDistEnd(self,event):
		self.DistEndShow.delete(0,END)
		self.DistEndShow.insert(END,"%1.3f" % event.widget.get() )
		self.DistEndShow.update_idletasks()
	# - - - - - - - - - - - - - - - - - -

	def HandleGo(self):
		self.FillGlobals()
		# Make list from all lights, then run.
		for OneActor in scene.Lights():
			LightList.append(OneActor)
		ParameterActions()
		P5FileActions()
		self.master.destroy()

	# - - - - - - - - - - - - - - - - - -

	def HandleSelect(self):
		# Undo the main panel, put the selection list in its place.
		global LightList
		self.FillGlobals()

		# Fill the global LightList so we don't have to worry about the App
		if app.Box.curselection():
			for i in app.Box.curselection():
				Name = app.Box.get(i)
				try:
					OneActor = scene.Actor(Name)
					if OneActor.IsLight():
						LightList.append(OneActor)
				except:
					pass
		ParameterActions()
		P5FileActions()
		self.master.destroy()

	# - - - - - - - - - - - - - - - - - -

	def HandleCancel(self):
		ParameterActions()
		P5FileActions()
		self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

app = App(root, "")
root.mainloop()

#------------------------------------------------------------
