#-----------------------------------------------------------------------------
# ZeroMorphs
# 1/3/05
# Copyright (c) 2005 David G. Drumright (ockham)
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
scene = poser.Scene()
# See if the figure is valid.
try:
    TheFig = scene.CurrentFigure()
except:
    raise "No Figure selected!"

# List of hand parts for 'full hands'
LeftFingers =  ["lThumb1",  "lThumb2",  "lThumb3",
                "lIndex1",  "lIndex2",  "lIndex3",
                "lMid1",    "lMid2",    "lMid3",
                "lRing1",   "lRing2",   "lRing3",
                "lPinky1",  "lPinky2",  "lPinky3",
                "lHand"]

RightFingers = ["rThumb1", "rThumb2", "rThumb3",
                "rIndex1", "rIndex2", "rIndex3",
                "rMid1",   "rMid2",   "rMid3",
                "rRing1",  "rRing2",  "rRing3",
                "rPinky1", "rPinky2", "rPinky3",
                "rHand"]

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Zero Morphs")

        self.StatusEntry = Entry(self.master,width=60)
        self.StatusEntry.grid(row=0,column=0,columnspan=2)

        # Lists
        self.ListScroll = Scrollbar(self.master, orient=VERTICAL)
        self.ListScroll.grid( row=2, column=0,sticky=N+S+E)
        self.List = Listbox(self.master, height=10, selectmode=MULTIPLE,yscrollcommand = self.ListScroll.set,exportselection=0)
        self.List.grid( row=2, column=1)
        # Set the scrollbar to work
        self.ListScroll["command"] = self.List.yview

        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Zero", command=self.HandleGo)
        self.buttonGo.grid(row=3, column=0)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=3, column=1)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        # Fill the list with parts of current figure, with "full hands" first


        self.List.insert(END,"Full Right Hand")
        self.List.insert(END,"Full Left Hand")
        for OnePart in TheFig.Actors():
            Name=OnePart.Name()
            self.List.insert(END,Name)

        self.ShowStatus("Highlight parts, or leave list alone to zero all.")

    # - - - - - - - - - - - - - - - - - -

    def SetZero(self,PartName):
        if PartName == "Full Right Hand":
            for OnePartName in RightFingers:
               OnePart=TheFig.Actor(OnePartName)
               for OneParm in OnePart.Parameters():
                   if OneParm.IsMorphTarget():
                      OneParm.SetValue(0.0)
                   if OneParm.IsValueParameter():
                      OneParm.SetValue(0.0)
        elif PartName == "Full Left Hand":
            for OnePartName in LeftFingers:
               OnePart=TheFig.Actor(OnePartName)
               for OneParm in OnePart.Parameters():
                   if OneParm.IsMorphTarget():
                      OneParm.SetValue(0.0)
                   if OneParm.IsValueParameter():
                      OneParm.SetValue(0.0)
        else:
            OnePart=TheFig.Actor(PartName)
            for OneParm in OnePart.Parameters():
                   if OneParm.IsMorphTarget():
                      OneParm.SetValue(0.0)
                   if OneParm.IsValueParameter():
                      OneParm.SetValue(0.0)


    # - - - - - - - - - - - - - - - - - -

    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleGo(self):
        # Action here
        Sels = self.List.curselection()
        if not Sels: # Use all but the first two
            for OneSel in range(2,self.List.size()):
                Name=self.List.get(int(OneSel))
                self.SetZero(Name)
        else: # Use only selected
            for OneSel in Sels:
                Name=self.List.get(int(OneSel))
                self.SetZero(Name)
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
